//
//  $Id: WXKABPeoplePickerWindowController.m 108 2009-06-24 14:54:10Z fujidana $
//  Copyright 2008 FUJIDANA. All rights reserved.
//

#import "WXKABPeoplePickerWindowController.h"
#import <AddressBook/AddressBookUI.h>

@implementation WXKABPeoplePickerWindowController

+ (id)sharedWindowController
{
	static WXKABPeoplePickerWindowController *peoplePickerWindowController;
	if (peoplePickerWindowController == nil)
	{
		peoplePickerWindowController = [[WXKABPeoplePickerWindowController alloc] init];
	}
	return peoplePickerWindowController;
}

- (id)init
{
	self = [super initWithWindowNibName:@"ABPeoplePickerWindow"];
	if (self)
	{
		[self setWindowFrameAutosaveName:@"ABPeoplePickerWindow"];
		[self window];
	}
	return self;
}

- (int)runModal
{
	return [NSApp runModalForWindow:[self window]];
}

- (void)beginSheetModalForWindow:(NSWindow *)window modalDelegate:(id)delegate didEndSelector:(SEL)didEndSelector contextInfo:(void *)contextInfo
{
	[NSApp beginSheet:[self window] modalForWindow:window modalDelegate:delegate didEndSelector:didEndSelector contextInfo:contextInfo];
}

- (IBAction)ok:(id)sender
{
	if ([[self window] isModalPanel])
	{
		[NSApp stopModalWithCode:NSOKButton];
	}
	else if ([[self window] isSheet])
	{
		[NSApp endSheet:[self window] returnCode:NSOKButton];
	}
	[[self window] orderOut:sender];
}

- (IBAction)cancel:(id)sender
{
	if ([[self window] isModalPanel])
	{
		[NSApp stopModalWithCode:NSCancelButton];
	}
	else if ([[self window] isSheet])
	{
		[NSApp endSheet:[self window] returnCode:NSCancelButton];
	}
	[[self window] orderOut:sender];
}

- (NSArray *)selectedPeople
{
	return [peoplePickerView selectedRecords];
}

@end
